/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.exporters;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomProperties;
import LegendaryCardMaker.CustomCardMaker.structure.ElementProperty;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMaker;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMaker;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import LegendaryCardMaker.LegendaryVillainMaker.VillainMaker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.w3c.dom.Element;

public class ExportHomeprintProgressBarDialog
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JProgressBar progressBar;
    private Task task;
    private int maxValue;
    private int currentValue;
    private LegendaryCardMaker lcm;
    private File folder;
    private JDialog frame;
    private String exportFileName = "export_";
    private List<CardMaker> cardMakers;

    public ExportHomeprintProgressBarDialog(int maxValue, LegendaryCardMaker lcm, File folder, List<CardMaker> cardMakers) {
        super(new BorderLayout());
        this.lcm = lcm;
        this.folder = folder;
        this.cardMakers = cardMakers;
        this.maxValue = maxValue;
        this.progressBar = new JProgressBar(0, maxValue);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public void createAndShowGUI() {
        this.frame = new JDialog();
        this.frame.setTitle("Exporting (" + (this.getCurrentValue() + 1) + "/" + "..." + ")...");
        this.frame.setModal(true);
        this.frame.setDefaultCloseOperation(2);
        this.setOpaque(true);
        this.frame.setContentPane(this);
        this.task = new Task();
        this.task.setBar(this);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void hideGUI() {
        this.frame.setVisible(false);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public static void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        int dpi = 300;
        FileOutputStream fos = new FileOutputStream(newFile);
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
        imageWriter.setOutput(ios);
        IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
        Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
        Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
        jfif.setAttribute("Xdensity", Integer.toString(dpi));
        jfif.setAttribute("Ydensity", Integer.toString(dpi));
        jfif.setAttribute("resUnits", "1");
        imageMetaData.setFromTree("javax_imageio_jpeg_image_1.0", tree);
        JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
        jpegParams.setCompressionMode(2);
        jpegParams.setCompressionQuality(1.0f);
        imageWriter.write(null, new IIOImage(image, null, imageMetaData), jpegParams);
        ios.close();
        imageWriter.dispose();
    }

    class Task
    extends SwingWorker<Void, Void> {
        private ExportHomeprintProgressBarDialog bar;

        Task() {
        }

        @Override
        public Void doInBackground() throws Exception {
            int max = 0;
            if (ExportHomeprintProgressBarDialog.this.cardMakers == null) {
                CardMaker sm;
                int i;
                int count;
                ExportHomeprintProgressBarDialog.this.cardMakers = new ArrayList();
                for (Hero hero : ((ExportHomeprintProgressBarDialog)ExportHomeprintProgressBarDialog.this).lcm.heroes) {
                    for (HeroCard hc : hero.cards) {
                        HeroMaker hm = new HeroMaker();
                        hm.setCard(hc);
                        count = hc.rarity.getCount();
                        if (hc.numberInDeck > 0) {
                            count = hc.numberInDeck;
                        }
                        i = 0;
                        while (i < count) {
                            ExportHomeprintProgressBarDialog.this.cardMakers.add(hm);
                            ++max;
                            ++i;
                        }
                    }
                }
                for (Villain villain : ((ExportHomeprintProgressBarDialog)ExportHomeprintProgressBarDialog.this).lcm.villains) {
                    for (VillainCard vc : villain.cards) {
                        VillainMaker vm = new VillainMaker();
                        vm.setCard(vc);
                        count = vc.cardType.getCount();
                        if (vc.numberInDeck > 0) {
                            count = vc.numberInDeck;
                        }
                        i = 0;
                        while (i < count) {
                            ExportHomeprintProgressBarDialog.this.cardMakers.add(vm);
                            ++max;
                            ++i;
                        }
                    }
                }
                for (SchemeCard schemeCard : ((ExportHomeprintProgressBarDialog)ExportHomeprintProgressBarDialog.this).lcm.schemes) {
                    sm = new SchemeMaker();
                    ((SchemeMaker)sm).setCard(schemeCard);
                    int i2 = 0;
                    while (i2 < schemeCard.numberInDeck) {
                        ExportHomeprintProgressBarDialog.this.cardMakers.add(sm);
                        ++max;
                        ++i2;
                    }
                }
                for (CustomCard customCard : ((ExportHomeprintProgressBarDialog)ExportHomeprintProgressBarDialog.this).lcm.customCards) {
                    sm = new CustomCardMaker();
                    ((CustomCardMaker)sm).setCard(customCard);
                    int numberInDeck = 1;
                    ElementProperty numberInDeckProp = customCard.template.getProperty(CustomProperties.NUMBERINDECK);
                    if (numberInDeckProp != null) {
                        try {
                            numberInDeck = Integer.parseInt(numberInDeckProp.getValue());
                        }
                        catch (Exception e) {
                            numberInDeck = 1;
                        }
                    }
                    int i3 = 0;
                    while (i3 < numberInDeck) {
                        ExportHomeprintProgressBarDialog.this.cardMakers.add(sm);
                        ++max;
                        ++i3;
                    }
                }
            } else {
                max = ExportHomeprintProgressBarDialog.this.cardMakers.size();
            }
            ExportHomeprintProgressBarDialog.this.setMaxValue(max);
            double d = 0.0;
            double progressIncrement = 100.0 / (double)max;
            ExportHomeprintProgressBarDialog.this.progressBar.setMaximum(100);
            int cardWidth = 750;
            int cardHeight = 1050;
            int dpi = 300;
            double xPadding = 0.02;
            double yPadding = 0.02;
            int w = cardWidth;
            int xPad = (int)((double)cardWidth * xPadding);
            int fullW = w + xPad + xPad;
            int h = cardHeight;
            int yPad = (int)((double)cardHeight * yPadding);
            int fullH = h + yPad + yPad;
            int i = 0;
            int j = 1;
            int type = 1;
            BufferedImage image = new BufferedImage(fullW * 3, fullH * 3, type);
            Graphics g = image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            int x = xPad;
            int y = yPad;
            for (CardMaker cm : ExportHomeprintProgressBarDialog.this.cardMakers) {
                BufferedImage bi = cm.generateCard();
                g.drawImage(bi, x, y, null);
                if ((x += bi.getWidth() + xPad + xPad) >= (xPad + xPad + bi.getWidth()) * 3) {
                    y += bi.getHeight() + yPad + yPad;
                    x = xPad;
                }
                if (++i == 9) {
                    i = 0;
                    x = xPad;
                    y = yPad;
                    try {
                        File newFile = new File(String.valueOf(((ExportHomeprintProgressBarDialog)ExportHomeprintProgressBarDialog.this).lcm.exportFolder) + File.separator + ExportHomeprintProgressBarDialog.this.exportFileName + j + ".jpg");
                        ExportHomeprintProgressBarDialog.exportToJPEG(image, newFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    g.dispose();
                    image = new BufferedImage(fullW * 3, fullH * 3, type);
                    g = image.getGraphics();
                    g.setColor(Color.white);
                    g.fillRect(0, 0, image.getWidth(), image.getHeight());
                    ++j;
                }
                ExportHomeprintProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportHomeprintProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportHomeprintProgressBarDialog.this.getMaxValue() + ")...");
                ExportHomeprintProgressBarDialog exportHomeprintProgressBarDialog = ExportHomeprintProgressBarDialog.this;
                exportHomeprintProgressBarDialog.currentValue = exportHomeprintProgressBarDialog.currentValue + 1;
                this.setProgress((int)(d += progressIncrement));
            }
            if (i < 9) {
                i = 0;
                try {
                    File newFile = new File(String.valueOf(((ExportHomeprintProgressBarDialog)ExportHomeprintProgressBarDialog.this).lcm.exportFolder) + File.separator + ExportHomeprintProgressBarDialog.this.exportFileName + j + ".jpg");
                    ExportHomeprintProgressBarDialog.exportToJPEG(image, newFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            return null;
        }

        @Override
        public void done() {
            this.bar.hideGUI();
        }

        public ExportHomeprintProgressBarDialog getBar() {
            return this.bar;
        }

        public void setBar(ExportHomeprintProgressBarDialog bar) {
            this.bar = bar;
        }
    }
}

